PSCAD 4.2.0

Settings
 {
 Id = "976141504.1144685571"
 Author = "jayas.jayas"
 Desc = "Parallel Transmission Line using Snapshot"
 Arch = "windows"
 Options = 0
 Build = 19
 Warn = 7
 Check = 15
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 0.5
  Step = 5e-005
  Plot = 5e-005
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = "Case3.snp"
  OFile = "noname.out"
  SFile = "Case3.snp"
  SnapTime = 0.2
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }


Global_Consts = 
  {
  f = 60.0 [Hz]
  }

 }

Definitions
 {
 Module("Plots_B1")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-18,-4,21,-4)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Text(1,-28,"Plots")
   Text(3,24,"B1 B3")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([18,18],0)
    {
    Title = "Plots at B1"
    Draw = 1
    Area = [0,0,720,1188]
    Posn = [18,18]
    Icon = [-1,-1]
    Extents = 0,0,720,1188
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,720,286],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(65275392,"V1a",0,,,)
     Curve(65109840,"V1b",1,,,)
     Curve(65088776,"V1c",2,,,)
     }
    Graph([0,286],[0,0,720,286],"Current")
     {
     Options = 9
     Units = ""
     Curve(65164600,"I1a",0,,,)
     Curve(65180928,"I1b",1,,,)
     Curve(65167512,"I1c",2,,,)
     }
    Graph([0,572],[0,0,720,286],"Current")
     {
     Options = 9
     Units = ""
     Curve(65171264,"I10",0,,,)
     }
    PGraph([0,858],[0,0,720,267],"PolyGraph")
     {
     Options = 2
     Curve(65410656,"Br1a",0,,,1)
     Curve(65112616,"Br1b",1,,,1)
     Curve(65153744,"Br1c",2,,,1)
     }
    }
   -Plot-([810,18],0)
    {
    Title = "Plots at B3"
    Draw = 1
    Area = [0,0,720,1188]
    Posn = [810,18]
    Icon = [-1,-1]
    Extents = 0,0,720,1188
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,720,286],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(65215920,"V3a",0,,,)
     Curve(65218736,"V3b",1,,,)
     Curve(65221648,"V3c",2,,,)
     }
    Graph([0,286],[0,0,720,286],"Current")
     {
     Options = 9
     Units = ""
     Curve(65224560,"I3a",0,,,)
     Curve(65227472,"I3b",1,,,)
     Curve(65230360,"I3c",2,,,)
     }
    Graph([0,572],[0,0,720,286],"Current")
     {
     Options = 9
     Units = ""
     Curve(65233272,"I30",0,,,)
     }
    PGraph([0,858],[0,0,720,267],"PolyGraph")
     {
     Options = 2
     Curve(65250896,"Br3a",0,,,1)
     Curve(65253728,"Br3b",1,,,1)
     Curve(65256504,"Br3c",2,,,1)
     }
    }
   }
  }
 Module("Controls")
  {
  Desc = ""
  FileDate = 1144685243
  Nodes = 
   {
   Output("F",36,18)
    {
    Type = Integer
    }
   Output("B",36,-36)
    {
    Type = Integer
    Dim  = [4]
    }
   Input("Flt_en",36,-18)
    {
    Type = Integer
    }
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Pen(Gray)
   Line(27,28,27,-43)
   Text(1,25,"Controls")
   Pen(Black)
   Line(27,18,36,18)
   Line(27,-36,36,-36)
   Line(34,-18,27,-18)
   Pen(Gray)
   Brush(,Gray)
   Rectangle(-3,-10,6,-7)
   Brush(,Silver)
   Rectangle(0,-13,3,0)
   Pen(ByNode)
   Brush(Hollow)
   Rectangle(-4,-18,7,3)
   }


  Page(B/A3,Landscape,16,[597,467],100)
   {
   -Sticky-([72,666],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,666,180,702
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "FAULT CONTROLS"
    }
   0.export([1494,1116],4,0,300)
    {
    Name = "F"
    }
   -Wire-([648,684],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([684,684],0,0,-1)
    {
    Name = "Tfs"
    }
   0.datalabel([684,720],0,0,-1)
    {
    Name = "Tfd"
    }
   0.datalabel([810,702],4,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([1404,1116],4,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([1404,1116],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -ControlPanel-([18,396],0)
    {
    Name = "SOURCE 2"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,576,126
    Slider(65356392)
    Meter(65393208)
    Slider(65353536)
    Meter(65281360)
    Meter(65131360)
    Meter(65158856)
    Meter(65262192)
    Meter(65265272)
    }
   -Sticky-([522,108],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 522,108,684,216
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust phase angle to obtain
the correct power flow. Adjust
voltage to obtain the matching
VAR flow at each end."
    }
   0.arrow_a([522,216],1,0,-1)
    {
    }
   -ControlPanel-([72,720],0)
    {
    Name = "Fault Location, Type, Start & Duration"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,432,126
    Dial(65305104)
    Dial(65336624)
    Slider(64696424)
    Slider(64693704)
    Slider(65365568)
    }
   0.datalabel([1530,720],3,0,-1)
    {
    Name = "B3T1"
    }
   0.datalabel([1530,774],3,0,-1)
    {
    Name = "B3T2"
    }
   0.datalabel([1530,828],3,0,-1)
    {
    Name = "B4T1"
    }
   0.datalabel([1404,972],6,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([1404,990],6,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([1404,1008],6,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([1404,1026],6,0,-1)
    {
    Name = "B4"
    }
   0.datamerge([1422,1044],4,0,290)
    {
    N = "4"
    Type = "1"
    Disp = "1"
    }
   0.export([1458,1062],4,0,310)
    {
    Name = "B"
    }
   -Sticky-([1260,162],0)
    {
    Name = ""
    Font = 1
    Bounds = 1260,162,1368,198
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "BREAKER CONTROLS"
    }
   -Wire-([648,720],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -ControlPanel-([1260,396],0)
    {
    Name = "B2 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(64650040)
    Slider(64660224)
    Slider(64684048)
    }
   0.datalabel([1530,882],3,0,-1)
    {
    Name = "B4T2"
    }
   -ControlPanel-([1260,630],0)
    {
    Name = "B3 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(64671176)
    Slider(64677128)
    Slider(64638208)
    }
   -ControlPanel-([1260,774],0)
    {
    Name = "B4 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(64679528)
    Slider(64635352)
    Slider(64632200)
    }
   0.var([1494,882],0,64632200,170)
    {
    Name = "B4T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([1494,828],0,64635352,150)
    {
    Name = "B4T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([1494,774],0,64638208,140)
    {
    Name = "B3T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "0.42"
    Units = "s"
    Collect = "1"
    }
   0.tfaultn([774,702],4,0,240)
    {
    TF = "Tfs"
    DF = "Tfd"
    }
   -Sticky-([18,198],0)
    {
    Name = ""
    Font = 1
    Bounds = 18,198,144,234
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "PREFAULT CONTROLS"
    }
   -Wire-([1872,486],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1872,306],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1872,342],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   0.logic([1908,486],6,0,90)
    {
    Type = "1"
    Inv = "0"
    }
   0.logic([1908,306],0,0,210)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1944,306],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([1944,270],0,64646144,10)
    {
    Name = "42-B1"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.datalabel([2052,306],4,0,-1)
    {
    Name = "B1"
    }
   -Wire-([1944,486],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([1944,432],6,64650040,60)
    {
    Name = "42-B2"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   -Wire-([1980,450],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.datalabel([2052,450],2,0,-1)
    {
    Name = "B2"
    }
   0.tbreakn([1818,306],4,0,200)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B1T1"
    TO2 = "B1T2"
    }
   0.datalabel([1530,342],3,0,-1)
    {
    Name = "B1T1"
    }
   0.datalabel([1530,396],3,0,-1)
    {
    Name = "B1T2"
    }
   0.datalabel([1530,450],3,0,-1)
    {
    Name = "B2T1"
    }
   0.var([1494,396],0,64657448,30)
    {
    Name = "B1 T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([1494,450],0,64660224,50)
    {
    Name = "B2 T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.datalabel([1530,504],3,0,-1)
    {
    Name = "B2T2"
    }
   0.var([1494,342],0,64664080,20)
    {
    Name = "B1 T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   -Sticky-([1404,162],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 1404,162,1566,234
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust breaker clearing time (T1)
and reclose time (T2) if needed."
    }
   0.logic([2016,306],6,0,220)
    {
    Type = "2"
    Inv = "0"
    }
   -Wire-([1890,864],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1890,684],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1890,720],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   0.logic([1926,864],6,0,190)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1854,774],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1962,684],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([1962,648],0,64671176,120)
    {
    Name = "42-B3"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   -Wire-([1962,864],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1998,828],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.datalabel([2070,684],4,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([2070,828],2,0,-1)
    {
    Name = "B4"
    }
   0.var([1494,720],0,64677128,130)
    {
    Name = "B3T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "0.35"
    Units = "s"
    Collect = "1"
    }
   0.var_switch([1962,810],6,64679528,160)
    {
    Name = "42-B4"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.tbreakn([1836,864],4,0,180)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B4T1"
    TO2 = "B4T2"
    }
   0.logic([2034,684],6,0,270)
    {
    Type = "2"
    Inv = "0"
    }
   0.var([1494,504],0,64684048,70)
    {
    Name = "B2 T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.tbreakn([1836,684],4,0,250)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B3T1"
    TO2 = "B3T2"
    }
   0.logic([2016,450],0,0,230)
    {
    Type = "2"
    Inv = "0"
    }
   0.tbreakn([1818,486],4,0,80)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B2T1"
    TO2 = "B2T2"
    }
   0.logic([2034,828],0,0,280)
    {
    Type = "2"
    Inv = "0"
    }
   0.logic([1926,684],0,0,260)
    {
    Type = "1"
    Inv = "0"
    }
   0.import([1674,396],0,0,40)
    {
    Name = "Flt_en"
    }
   -Wire-([1710,396],0,0,-1)
    {
    Vertex="0,0;162,0"
    }
   -Wire-([1728,396],0,0,-1)
    {
    Vertex="0,0;0,378"
    }
   -Wire-([1728,774],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   0.var([612,720],0,64693704,110)
    {
    Name = "Duration "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.11"
    Units = ""
    Collect = "1"
    }
   0.var([612,684],0,64696424,100)
    {
    Name = "Fault Start "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.25"
    Units = "s"
    Collect = "1"
    }
   -Sticky-([234,864],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 234,864,342,1062
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> A-g
  2=> B-g
  3=> C-g
  4=> AB-g
  5=> AC-g
  6=> BC-g
  7=> ABC-g
  8=> AB 
  9=> AC 
10=>No fault
11=> No fault (0)"
    }
   -Sticky-([72,864],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 72,864,216,1170
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> FT1:
          Between Source
          and  B1
  2=> FT2: 
          Between B1 
          and Line
  3=> FT3: 
          Between Line 1
          and B2
  4=> FT4: 
          Between Source
          and B2
  5=> FT5:
          Between B3
          and Line 2
  6=> FT6:
          Between Line 2 
          and B4 "
    }
   -Sticky-([1260,954],0)
    {
    Name = ""
    Font = 1
    Bounds = 1260,954,1368,990
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Exports to Main Page"
    }
   -ControlPanel-([1260,252],0)
    {
    Name = "B1 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(64646144)
    Slider(64664080)
    Slider(64657448)
    }
   -ControlPanel-([954,180],0)
    {
    Name = "Recorders"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,144,126
    Slider(65444704)
    Slider(65441664)
    }
   -ControlPanel-([882,342],0)
    {
    Name = "Recorder Control"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,288,126
    Switch(65453320)
    Switch(65456040)
    Switch(65458760)
    Switch(65461480)
    }
   -Sticky-([954,126],0)
    {
    Name = ""
    Font = 1
    Bounds = 954,126,1062,162
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Playback  Recorders"
    }
   -Sticky-([918,468],0)
    {
    Name = ""
    Font = 1
    Bounds = 918,468,1152,576
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
To turn the Recorders on, click on the switch.
On = Recorder will record data.
Off = Recorder will NOT record data.

You can turn on each recorder individually."
    }
   -ControlPanel-([18,252],0)
    {
    Name = "SOURCE 1"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,576,126
    Slider(65350680)
    Meter(65387248)
    Slider(65347768)
    Meter(65278168)
    Meter(65289080)
    Meter(65161688)
    Meter(65341864)
    Meter(65259280)
    }
   -Divider-([18,612],0)
    {
    Size(1188,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([1206,918],0)
    {
    Size(1170,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([792,72],0)
    {
    Size(0,540)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([1206,72],0)
    {
    Size(0,1440)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   }
  }
 Module("Plots_B2")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Line(-18,-4,21,-4)
   Text(1,-28,"Plots")
   Text(3,24,"B2 B4")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([18,36],0)
    {
    Title = "Plots at B4"
    Draw = 1
    Area = [0,0,738,1152]
    Posn = [18,36]
    Icon = [-1,-1]
    Extents = 0,0,738,1152
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,738,277],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(65236352,"V4a",0,,,)
     Curve(65407520,"V4b",1,,,)
     Curve(65286168,"V4c",2,,,)
     }
    Graph([0,277],[0,0,738,277],"Current")
     {
     Options = 9
     Units = ""
     Curve(65239264,"I4a",0,,,)
     Curve(65242352,"I4b",1,,,)
     Curve(65245184,"I4c",2,,,)
     }
    Graph([0,554],[0,0,738,277],"Current")
     {
     Options = 9
     Units = ""
     Curve(65248096,"I40",0,,,)
     }
    PGraph([0,831],[0,0,738,258],"PolyGraph")
     {
     Options = 2
     Curve(64903464,"Br4a",0,,,1)
     Curve(65268184,"Br4b",1,,,1)
     Curve(65270960,"Br4c",2,,,1)
     }
    }
   -Plot-([792,36],0)
    {
    Title = "Plots at B2"
    Draw = 1
    Area = [0,0,738,1152]
    Posn = [792,36]
    Icon = [-1,-1]
    Extents = 0,0,738,1152
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,738,277],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(65091688,"V2a",0,,,)
     Curve(65094600,"V2b",1,,,)
     Curve(65123512,"V2c",2,,,)
     }
    Graph([0,277],[0,0,738,277],"Current")
     {
     Options = 9
     Units = ""
     Curve(65083032,"I2a",0,,,)
     Curve(65085864,"I2b",1,,,)
     Curve(65177848,"I2c",2,,,)
     }
    Graph([0,554],[0,0,738,277],"Current")
     {
     Options = 9
     Units = ""
     Curve(65175072,"I20",0,,,)
     }
    PGraph([0,831],[0,0,738,258],"PolyGraph")
     {
     Options = 2
     Curve(65101584,"Br2a",0,,,1)
     Curve(65115392,"Br2b",1,,,1)
     Curve(42954016,"Br2c",2,,,1)
     }
    }
   }
  }
 Module("Main")
  {
  Desc = "Main Page"
  FileDate = 1144685242
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(B/A3,Landscape,16,[597,467],100)
   {
   0.pgb([1692,1224],0,64903464,1100)
    {
    Name = "Br4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([2178,162],2,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([2214,162],2,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([2250,162],2,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([2178,342],2,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([2214,342],2,0,-1)
    {
    Name = "I2B"
    }
   0.datalabel([2250,342],2,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([1260,1188],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datatap([1278,1224],0,0,280)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1278,1260],0,0,380)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([2070,162],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([2106,162],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([2142,162],2,0,-1)
    {
    Name = "V1C"
    }
   0.datalabel([2070,342],6,0,-1)
    {
    Name = "V2A"
    }
   0.datalabel([2106,342],6,0,-1)
    {
    Name = "V2B"
    }
   0.datalabel([2142,342],6,0,-1)
    {
    Name = "V2C"
    }
   -Wire-([1998,414],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1656,1386],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1656,1350],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1656,1296],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1656,1260],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1422,1422],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1422,1386],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1422,1350],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1296,1350],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1296,1386],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1296,1422],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1530,1224],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1530,1260],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1530,1296],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1530,1350],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1530,1386],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([1404,1296],0,0,490)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1404,1260],0,0,420)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1404,1224],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1404,1260],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1404,1296],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1278,1296],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1278,1260],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1278,1224],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datatap([1278,1296],0,0,470)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1404,1224],0,0,340)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1386,1188],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([252,1116],2,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([162,1206],2,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([198,1206],2,0,-1)
    {
    Name = "FT2"
    }
   0.datalabel([234,1206],2,0,-1)
    {
    Name = "FT3"
    }
   -Wire-([216,1296],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.datalabel([162,1458],0,0,-1)
    {
    Name = "F1"
    }
   0.datalabel([198,1458],0,0,-1)
    {
    Name = "F2"
    }
   0.datalabel([234,1458],0,0,-1)
    {
    Name = "F3"
    }
   0.datalabel([252,1368],2,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([1422,1458],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1296,1458],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([756,720],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([288,612],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([306,720],0,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([306,738],0,0,-1)
    {
    Name = "F1"
    }
   0.pgb([1818,1296],0,65061752,520)
    {
    Name = "V3rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.pgb([1818,1332],0,65064528,530)
    {
    Name = "V4rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.datalabel([738,522],0,0,-1)
    {
    Name = "FT3"
    }
   0.datalabel([738,540],0,0,-1)
    {
    Name = "F3"
    }
   0.datalabel([738,756],0,0,-1)
    {
    Name = "FT6"
    }
   0.datalabel([738,774],0,0,-1)
    {
    Name = "F6"
    }
   0.datalabel([288,1116],2,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([216,1116],2,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([306,1206],2,0,-1)
    {
    Name = "FT5"
    }
   0.datalabel([342,1458],0,0,-1)
    {
    Name = "F6"
    }
   0.datalabel([504,522],0,0,-1)
    {
    Name = "FT2"
    }
   0.datalabel([504,540],0,0,-1)
    {
    Name = "F2"
    }
   0.datalabel([504,756],0,0,-1)
    {
    Name = "FT5"
    }
   -Wire-([486,720],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([450,504],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1998,828],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2016,864],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([2016,450],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([2016,684],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([774,1368],0,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([774,1404],0,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([774,1440],0,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([900,1368],0,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([900,1404],0,0,-1)
    {
    Name = "I2B"
    }
   0.pgb([936,1368],0,65083032,1020)
    {
    Name = "I2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.0"
    }
   0.pgb([936,1404],0,65085864,890)
    {
    Name = "I2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.0"
    }
   0.pgb([810,1314],0,65088776,410)
    {
    Name = "V1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "250.0"
    }
   0.pgb([936,1242],0,65091688,260)
    {
    Name = "V2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "250.0"
    }
   0.pgb([936,1278],0,65094600,370)
    {
    Name = "V2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "250.0"
    }
   0.datalabel([1026,1224],0,0,-1)
    {
    Name = "Br1A"
    }
   0.datalabel([1026,1260],0,0,-1)
    {
    Name = "Br1B"
    }
   0.datalabel([1026,1296],0,0,-1)
    {
    Name = "Br1C"
    }
   0.datalabel([1152,1224],0,0,-1)
    {
    Name = "Br2A"
    }
   0.datalabel([1152,1260],0,0,-1)
    {
    Name = "Br2B"
    }
   0.pgb([1188,1224],0,65101584,1140)
    {
    Name = "Br2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([1188,1296],0,42954016,1080)
    {
    Name = "Br2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([1026,1350],0,0,-1)
    {
    Name = "P1"
    }
   0.pgb([810,1278],0,65109840,320)
    {
    Name = "V1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "250.0"
    }
   0.pgb([1062,1260],0,65112616,1130)
    {
    Name = "Br1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([1188,1260],0,65115392,1120)
    {
    Name = "Br2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datatap([756,1242],0,0,230)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([756,1278],0,0,290)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([738,1206],2,0,-1)
    {
    Name = "V1"
    }
   0.datalabel([774,1242],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([774,1278],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([900,1278],2,0,-1)
    {
    Name = "V2B"
    }
   0.pgb([936,1314],0,65123512,460)
    {
    Name = "V2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "250.0"
    }
   -Wire-([1026,1422],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1026,1422],0,0,-1)
    {
    Name = "S1W"
    }
   -Wire-([1026,1458],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1026,1458],0,0,-1)
    {
    Name = "S1Q"
    }
   -Wire-([1152,1422],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1152,1458],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1152,1458],0,0,-1)
    {
    Name = "S2Q"
    }
   0.datalabel([900,1242],2,0,-1)
    {
    Name = "V2A"
    }
   0.pgb([1188,1350],0,65131360,1000)
    {
    Name = "P2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.datalabel([1152,1422],0,0,-1)
    {
    Name = "S2W"
    }
   -Wire-([1152,1386],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1152,1386],0,0,-1)
    {
    Name = "Q2"
    }
   -Wire-([1152,1350],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1152,1350],0,0,-1)
    {
    Name = "P2"
    }
   -Wire-([1152,1296],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1152,1260],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1152,1224],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1152,1296],0,0,-1)
    {
    Name = "Br2C"
    }
   0.datalabel([900,1440],0,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([900,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([900,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([900,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([774,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([774,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([774,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1026,1224],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1026,1260],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1026,1296],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1026,1350],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1026,1386],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([900,1314],2,0,-1)
    {
    Name = "V2C"
    }
   0.datatap([882,1314],0,0,430)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([882,1278],0,0,350)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([882,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([882,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([882,1314],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([774,1314],2,0,-1)
    {
    Name = "V1C"
    }
   -Wire-([756,1314],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([756,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([756,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datatap([756,1314],0,0,390)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1026,1386],0,0,-1)
    {
    Name = "Q1"
    }
   0.pgb([1062,1296],0,65153744,1090)
    {
    Name = "Br1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datatap([882,1242],0,0,250)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([864,1206],2,0,-1)
    {
    Name = "V2"
    }
   -Wire-([864,1206],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.pgb([1188,1386],0,65158856,880)
    {
    Name = "Q2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([1062,1386],0,65161688,920)
    {
    Name = "Q1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([810,1368],0,65164600,1050)
    {
    Name = "I1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "1.5"
    }
   0.pgb([810,1440],0,65167512,840)
    {
    Name = "I1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "1.5"
    }
   -Wire-([900,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([774,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([810,1476],0,65171264,760)
    {
    Name = "I10"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.5"
    Max = "0.3"
    }
   0.datalabel([900,1476],0,0,-1)
    {
    Name = "I20"
    }
   0.pgb([936,1476],0,65175072,730)
    {
    Name = "I20"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.4"
    Max = "0.5"
    }
   0.pgb([936,1440],0,65177848,810)
    {
    Name = "I2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.0"
    }
   0.pgb([810,1404],0,65180928,940)
    {
    Name = "I1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "1.5"
    }
   -Wire-([738,1206],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([774,1476],0,0,-1)
    {
    Name = "I10"
    }
   0.datalabel([1260,1188],2,0,-1)
    {
    Name = "V3"
    }
   0.datalabel([1296,1224],2,0,-1)
    {
    Name = "V3A"
    }
   0.datalabel([1296,1260],2,0,-1)
    {
    Name = "V3B"
    }
   0.datalabel([1296,1296],2,0,-1)
    {
    Name = "V3C"
    }
   0.datalabel([1422,1224],2,0,-1)
    {
    Name = "V4A"
    }
   0.datalabel([1422,1260],2,0,-1)
    {
    Name = "V4B"
    }
   0.datalabel([1422,1296],2,0,-1)
    {
    Name = "V4C"
    }
   0.datalabel([2070,576],2,0,-1)
    {
    Name = "V3A"
    }
   0.datalabel([2106,576],2,0,-1)
    {
    Name = "V3B"
    }
   0.datalabel([2142,576],2,0,-1)
    {
    Name = "V3C"
    }
   0.datalabel([2070,756],6,0,-1)
    {
    Name = "V4A"
    }
   0.datalabel([2106,756],6,0,-1)
    {
    Name = "V4B"
    }
   0.datalabel([2142,756],6,0,-1)
    {
    Name = "V4C"
    }
   0.datalabel([1296,1350],0,0,-1)
    {
    Name = "I3A"
    }
   0.datalabel([1296,1386],0,0,-1)
    {
    Name = "I3B"
    }
   0.datalabel([1296,1422],0,0,-1)
    {
    Name = "I3C"
    }
   0.datalabel([1296,1458],0,0,-1)
    {
    Name = "I30"
    }
   0.datalabel([1422,1350],0,0,-1)
    {
    Name = "I4A"
    }
   0.datalabel([1422,1386],0,0,-1)
    {
    Name = "I4B"
    }
   0.datalabel([1422,1422],0,0,-1)
    {
    Name = "I4C"
    }
   0.datalabel([1422,1458],0,0,-1)
    {
    Name = "I40"
    }
   0.datalabel([2178,576],2,0,-1)
    {
    Name = "I3A"
    }
   0.datalabel([2214,576],2,0,-1)
    {
    Name = "I3B"
    }
   0.datalabel([2250,576],2,0,-1)
    {
    Name = "I3C"
    }
   0.datalabel([2178,756],2,0,-1)
    {
    Name = "I4A"
    }
   0.datalabel([2214,756],2,0,-1)
    {
    Name = "I4B"
    }
   0.datalabel([2250,756],2,0,-1)
    {
    Name = "I4C"
    }
   0.datalabel([2250,306],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([2250,486],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([1530,1350],0,0,-1)
    {
    Name = "P3"
    }
   0.datalabel([1530,1386],0,0,-1)
    {
    Name = "Q3"
    }
   0.datalabel([1530,1224],0,0,-1)
    {
    Name = "Br3A"
    }
   0.datalabel([1530,1260],0,0,-1)
    {
    Name = "Br3B"
    }
   0.datalabel([1530,1296],0,0,-1)
    {
    Name = "Br3C"
    }
   -Wire-([1656,1224],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1656,1224],0,0,-1)
    {
    Name = "Br4A"
    }
   0.datalabel([1656,1260],0,0,-1)
    {
    Name = "Br4B"
    }
   0.datalabel([1656,1296],0,0,-1)
    {
    Name = "Br4C"
    }
   0.datalabel([1656,1350],0,0,-1)
    {
    Name = "P4"
    }
   0.datalabel([1656,1386],0,0,-1)
    {
    Name = "Q4"
    }
   0.pgb([1332,1224],0,65215920,310)
    {
    Name = "V3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1332,1260],0,65218736,400)
    {
    Name = "V3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1332,1296],0,65221648,480)
    {
    Name = "V3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1332,1350],0,65224560,960)
    {
    Name = "I3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "8.0"
    }
   0.pgb([1332,1386],0,65227472,850)
    {
    Name = "I3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "8.0"
    }
   0.pgb([1332,1422],0,65230360,780)
    {
    Name = "I3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "8.0"
    }
   0.pgb([1332,1458],0,65233272,710)
    {
    Name = "I30"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "3.0"
    }
   0.pgb([1458,1224],0,65236352,360)
    {
    Name = "V4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "250.0"
    }
   0.pgb([1458,1350],0,65239264,900)
    {
    Name = "I4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.0"
    }
   0.pgb([1458,1386],0,65242352,820)
    {
    Name = "I4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.0"
    }
   0.pgb([1458,1422],0,65245184,740)
    {
    Name = "I4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.0"
    }
   0.pgb([1458,1458],0,65248096,700)
    {
    Name = "I40"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.3"
    Max = "0.5"
    }
   0.pgb([1566,1224],0,65250896,1110)
    {
    Name = "Br3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([1566,1260],0,65253728,1070)
    {
    Name = "Br3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([1566,1296],0,65256504,1040)
    {
    Name = "Br3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([1566,1386],0,65259280,790)
    {
    Name = "Q3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([1692,1350],0,65262192,860)
    {
    Name = "P4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.pgb([1692,1386],0,65265272,770)
    {
    Name = "Q4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([1692,1260],0,65268184,1060)
    {
    Name = "Br4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([1692,1296],0,65270960,1010)
    {
    Name = "Br4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([504,774],0,0,-1)
    {
    Name = "F5"
    }
   0.datalabel([324,1116],2,0,-1)
    {
    Name = "B4"
    }
   0.pgb([810,1242],0,65275392,240)
    {
    Name = "V1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "250.0"
    }
   0.pgb([1818,1224],0,65278168,440)
    {
    Name = "V1rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   -Wire-([792,504],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   0.pgb([1818,1260],0,65281360,510)
    {
    Name = "V2rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   -Wire-([900,612],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.datalabel([936,738],0,0,-1)
    {
    Name = "F4"
    }
   -Wire-([954,612],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.pgb([1458,1296],0,65286168,500)
    {
    Name = "V4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "250.0"
    }
   0.pgb([1062,1350],0,65289080,1030)
    {
    Name = "P1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.recorder2_0([2142,414],0,0,1290)
    {
    FName = "stn2"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "2"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V2a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V2b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V2c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I2a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I2b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I2c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   -Wire-([2016,270],0,0,-1)
    {
    Vertex="0,0;0,594"
    }
   0.datalabel([1350,918],4,0,-1)
    {
    Name = "Breaker"
    }
   0.datalabel([180,1134],0,0,-1)
    {
    Name = "Breaker"
    }
   0.var_pot([144,1332],0,65305104,270)
    {
    Name = "Fault location"
    Group = ""
    Display = "0"
    NDP = "6"
    Value = "5"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "10.0"
    }
   0.unity([216,1332],0,0,300)
    {
    IType = "2"
    OType = "1"
    }
   0.datalabel([1386,1188],2,0,-1)
    {
    Name = "V4"
    }
   0.mux_array([234,1404],6,0,610)
    {
    DPath = "0"
    }
   -Wire-([306,1134],0,0,-1)
    {
    Vertex="0,0;-126,0"
    }
   0.datatap([216,1116],6,0,650)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([252,1116],6,0,640)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([288,1116],6,0,630)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([324,1116],6,0,620)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([162,1206],6,0,1220)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([198,1206],6,0,1210)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([234,1206],6,0,1200)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([270,1206],6,0,1190)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([306,1206],6,0,1180)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([342,1206],6,0,1170)
    {
    Index = "6"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([270,1206],2,0,-1)
    {
    Name = "FT4"
    }
   -Wire-([324,1224],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   0.datatap([162,1458],0,0,990)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([198,1458],0,0,980)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([234,1458],0,0,970)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([270,1458],0,0,950)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([306,1458],0,0,930)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([342,1458],0,0,910)
    {
    Index = "6"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([342,1206],2,0,-1)
    {
    Name = "FT6"
    }
   0.datalabel([306,1458],0,0,-1)
    {
    Name = "F5"
    }
   -Wire-([324,1440],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   0.datalabel([270,1458],0,0,-1)
    {
    Name = "F4"
    }
   0.datalabel([1350,936],4,0,-1)
    {
    Name = "Faulttype"
    }
   0.breaker3([864,720],0,0,660)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0 [kA]"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B4"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005 [s]"
    IBRA = "I4A"
    IBRB = "I4B"
    IBRC = "I4C"
    IBR0 = "I40"
    SBRA = "Br4A"
    SBRB = "Br4B"
    SBRC = "Br4C"
    BP = "P4"
    BQ = "Q4"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "69.93 [MW]"
    Q = "-17 [MVAR]"
    }
   0.var_pot([324,1332],2,65336624,330)
    {
    Name = "Fault Type"
    Group = ""
    Display = "0"
    NDP = "10"
    Value = "1"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "0"
    }
   0.unity([252,1332],4,0,590)
    {
    IType = "2"
    OType = "1"
    }
   0.datalabel([252,1332],1,0,-1)
    {
    Name = "Faulttype"
    }
   -Wire-([252,1296],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.pgb([1566,1350],0,65341864,870)
    {
    Name = "P3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.breaker3([378,720],4,0,670)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0 [kA]"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B3"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005 [s]"
    IBRA = "I3A"
    IBRB = "I3B"
    IBRC = "I3C"
    IBR0 = "I30"
    SBRA = "Br3A"
    SBRB = "Br3B"
    SBRC = "Br3C"
    BP = "P3"
    BQ = "Q3"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "-68.59 [MW]"
    Q = "4.72 [MVAR]"
    }
   0.var([144,684],3,65347768,100)
    {
    Name = "Voltage"
    Group = "SS1"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   0.var([198,684],3,65350680,110)
    {
    Name = "Ph Angle"
    Group = "SS1"
    Display = "0"
    Max = "180"
    Min = "0.0"
    Value = "0.0"
    Units = "deg"
    Collect = "1"
    }
   0.var([1080,684],5,65353536,160)
    {
    Name = "Voltage"
    Group = "SS2"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   0.var([1026,684],5,65356392,150)
    {
    Name = "Ph Angle"
    Group = "SS2"
    Display = "0"
    Max = "180"
    Min = "-180"
    Value = "20.0"
    Units = "deg"
    Collect = "1"
    }
   0.tpflt([468,504],0,0,1310)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([774,504],4,0,1300)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([774,738],4,0,1250)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([972,702],4,0,1260)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.var([180,1512],0,65365568,540)
    {
    Name = "Rf"
    Group = ""
    Display = "0"
    Max = "50"
    Min = "0.001"
    Value = "0.001"
    Units = "ohm"
    Collect = "1"
    }
   0.datalabel([288,1512],0,0,-1)
    {
    Name = "Ron"
    }
   0.annotation([180,1494],0,0,-1)
    {
    AL1 = "Rf"
    AL2 = ""
    }
   0.recorder2_0([2142,828],0,0,1230)
    {
    FName = "stn4"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "4"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V2a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V2b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V2c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I2a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I2b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I2c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.datalabel([2250,720],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([2250,900],0,0,-1)
    {
    Name = "Fault"
    }
   0.tpflt([270,702],0,0,1280)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.datalabel([936,720],0,0,-1)
    {
    Name = "FT4"
    }
   -Wire-([450,720],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.tpflt([468,738],0,0,1270)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.pgb([1062,1422],0,65387248,830)
    {
    Name = "PS1"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1062,1458],0,65390240,750)
    {
    Name = "QS1"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([1188,1422],0,65393208,800)
    {
    Name = "PS2"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1188,1458],0,65396120,720)
    {
    Name = "QS2"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   -Bus-([342,486],0,32028064,-1)
    {
    P1 = [0,0]
    P2 = [0,270]
    I = 1
    NAME = BUS1
    BASKV = 0
    IDE = 0
    GL = 0
    BL = 0
    AREA = 1
    ZONE = 0
    VM = 0
    VA = 0
    OWNER = 1
    }
   0.breaker3([378,504],4,0,690)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0 [kA]"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B1"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005 [s]"
    IBRA = "I1A"
    IBRB = "I1B"
    IBRC = "I1C"
    IBR0 = "I10"
    SBRA = "Br1A"
    SBRB = "Br1B"
    SBRC = "Br1C"
    BP = "P1"
    BQ = "Q1"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "-68.7 [MW]"
    Q = "4.957 [MVAR]"
    }
   -Bus-([900,450],0,32030280,-1)
    {
    P1 = [0,0]
    P2 = [0,324]
    I = 1
    NAME = BUS2
    BASKV = 0
    IDE = 0
    GL = 0
    BL = 0
    AREA = 1
    ZONE = 0
    VM = 0
    VA = 0
    OWNER = 1
    }
   0.breaker3([864,504],0,0,680)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0 [kA]"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B2"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005 [s]"
    IBRA = "I2A"
    IBRB = "I2B"
    IBRC = "I2C"
    IBR0 = "I20"
    SBRA = "Br2A"
    SBRB = "Br2B"
    SBRC = "Br2C"
    BP = "P2"
    BQ = "Q2"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "70.11 [MW]"
    Q = "-17.53 [MVAR]"
    }
   0.pgb([1458,1260],0,65407520,450)
    {
    Name = "V4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "250.0"
    }
   0.pgb([1062,1224],0,65410656,1150)
    {
    Name = "Br1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   -Sticky-([738,1116],0)
    {
    Name = ""
    Font = 1
    Bounds = 738,1116,846,1152
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "OUTPUT CHANNELS"
    }
   0.mux_array([234,1260],0,0,1160)
    {
    DPath = "0"
    }
   -Wire-([216,1512],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.recorder2_0([2142,648],0,0,1240)
    {
    FName = "stn3"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "3"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.recorder2_0([2142,234],0,0,1320)
    {
    FName = "stn1"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "1"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.const([1818,198],1,0,20)
    {
    Name = ""
    Value = "10.0"
    }
   0.select([1962,414],6,0,560)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.const([1926,378],1,0,80)
    {
    Name = ""
    Value = "10.0"
    }
   0.const([1926,612],1,0,180)
    {
    Name = ""
    Value = "10.0"
    }
   0.const([1926,792],1,0,210)
    {
    Name = ""
    Value = "10.0"
    }
   0.var([1944,270],0,65441664,40)
    {
    Name = "Stop"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.5"
    Units = "s"
    Collect = "1"
    }
   0.var([1782,540],0,65444704,120)
    {
    Name = "Start"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.2"
    Units = "s"
    Collect = "1"
    }
   0.select([1854,234],6,0,550)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([1980,270],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1890,234],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   -Wire-([1818,270],0,0,-1)
    {
    Vertex="0,0;0,594"
    }
   -Wire-([1818,450],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.select([1962,828],6,0,220)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([1998,648],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.select([1962,648],6,0,190)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([1890,864],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1890,684],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([1854,162],1,65453320,10)
    {
    Name = "en Record1"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([1962,342],1,65456040,60)
    {
    Name = "en Record2"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([1962,576],1,65458760,140)
    {
    Name = "en Record3"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([1962,756],1,65461480,200)
    {
    Name = "en Record4"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.datalabel([1350,972],4,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([1602,972],0,0,-1)
    {
    Vertex="0,0;-252,0"
    }
   -Wire-([1350,936],0,0,-1)
    {
    Vertex="0,0;252,0"
    }
   -Wire-([1602,918],0,0,-1)
    {
    Vertex="0,0;-252,0"
    }
   -Sticky-([18,36],0)
    {
    Name = ""
    Font = 1
    Bounds = 18,36,612,252
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Description: 
- Two Thevinen Impedance sources connected via two parallel 100km transmission lines.  
- System voltage is 230kV settable via source equivalents.
- Simulates two substations connected via two transmission lines.
- Six fault positions for full fault control ahead and behind station relays.
- Four breakers are independently timed controlled. (Default is closed).
- Independent breaker pole tripping is possible.
"
    }
   -TLine-([504,504],0,109283368,-1)
    {
    Name = "LINE1"
    Date = 1144685243
    Freq = "$(f)"
    Length = "100.0 [km]"
    Dim = 3
    Mode = 1
    Vertex="0,0;18,0;198,0;216,0"
    PageLayer(A/A4,Landscape,16,[597,467],100)
     {
     0.Line_FreDep_Options([738,378],0,109281832,-1)
      {
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      FT = "2000 [Hz]"
      ZMaxP = "20"
      AMaxP = "20"
      ZMaxE = "2 [%]"
      AMaxE = "2 [%]"
      Interp1 = "1"
      Output = "0"
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      Inflen = "0"
      }
     0.Line_Ground([630,702],0,109432424,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.SequenceInfo([162,450],0,32092192,-1)
      {
      Mode = "0"
      X1 = "3.57448095"
      Y1 = "50.7762676"
      X2 = "3.57448095"
      Y2 = "50.7762676"
      X3 = "36.3152201"
      Y3 = "132.647323"
      X4 = "1.0e-005"
      Y4 = "0.000327117946"
      X5 = "0.0"
      Y5 = "0.0"
      X6 = "1.0e-005"
      Y6 = "0.000232266098"
      M1 = "50.9019279149"
      P1 = "85.9732100966"
      M2 = "50.9019279149"
      P2 = "85.9732100966"
      M3 = "137.528569795"
      P3 = "74.6891426178"
      M4 = "0.000327270760373"
      P4 = "88.249012563"
      M5 = "0.0"
      P5 = "0.0"
      M6 = "0.000232481268665"
      P6 = "87.5347062197"
      }
     0.Line_Tower_3_Delta([810,612],0,109506256,-1)
      {
      TName = "3H5"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mho/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "..\\conductor.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "..\\conductor.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "10 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NG1 = "4"
      NG2 = "5"
      }
     }
    }
   -TLine-([504,720],0,32093920,-1)
    {
    Name = "LINE2"
    Date = 1144685244
    Freq = "$(f)"
    Length = "100.0 [km]"
    Dim = 3
    Mode = 1
    Vertex="0,0;18,0;198,0;216,0"
    PageLayer(A/A4,Landscape,16,[597,467],100)
     {
     0.Line_FreDep_Options([738,378],0,32095144,-1)
      {
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      FT = "2000 [Hz]"
      ZMaxP = "20"
      AMaxP = "20"
      ZMaxE = "2 [%]"
      AMaxE = "2 [%]"
      Interp1 = "1"
      Output = "0"
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      Inflen = "0"
      }
     0.Line_Ground([630,702],0,32072728,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.SequenceInfo([180,468],0,32073072,-1)
      {
      Mode = "0"
      X1 = "3.57448095"
      Y1 = "50.7762676"
      X2 = "3.57448095"
      Y2 = "50.7762676"
      X3 = "36.3152201"
      Y3 = "132.647323"
      X4 = "1.0e-005"
      Y4 = "0.000327117946"
      X5 = "0.0"
      Y5 = "0.0"
      X6 = "1.0e-005"
      Y6 = "0.000232266098"
      M1 = "50.9019279149"
      P1 = "85.9732100966"
      M2 = "50.9019279149"
      P2 = "85.9732100966"
      M3 = "137.528569795"
      P3 = "74.6891426178"
      M4 = "0.000327270760373"
      P4 = "88.249012563"
      M5 = "0.0"
      P5 = "0.0"
      M6 = "0.000232481268665"
      P6 = "87.5347062197"
      }
     0.Line_Tower_3_Delta([810,612],0,32073336,-1)
      {
      TName = "3H5"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mho/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "..\\conductor.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "..\\conductor.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "10 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NG1 = "4"
      NG2 = "5"
      }
     }
    }
   -Wire-([792,720],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   0.source3R([1044,612],2,0,580)
    {
    Name = "Source2"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S2W"
    Q = "S2Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   -Sticky-([990,504],0)
    {
    Name = ""
    Font = 1
    Bounds = 990,504,1080,540
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 2"
    }
   -Sticky-([126,504],0)
    {
    Name = ""
    Font = 1
    Bounds = 126,504,216,540
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 1"
    }
   -Wire-([342,612],0,0,-1)
    {
    Vertex="0,0;-126,0"
    }
   0.source3R([180,612],6,0,570)
    {
    Name = "Source1"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S1W"
    Q = "S1Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   .Plots_B2([864,396],0,0,50)
    {
    }
   .Controls([1638,954],4,0,600)
    {
    }
   .Plots_B1([378,396],0,0,30)
    {
    }
   -Sticky-([1188,36],0)
    {
    Name = ""
    Font = 1
    Bounds = 1188,36,1584,144
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
This case uses global substitutions.  To change between 50Hz/60Hz. select Global Substitutions (Ctrl-G).  In the pop-up window, change the value of f to the desired frequency.
"
    }
   -Divider-([18,1044],0)
    {
    Size(2376,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Sticky-([558,18],0)
    {
    Name = ""
    Font = 1
    Bounds = 558,18,1134,234
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\

To Create a Snapshot:
   1.  Edit Project Settings.
   2.  Under Timed Snapshot(s) select Single, (once only).  Modify the start time and file name if desired.
   3.  Run the case

To Run from a Snapshot:
   1.  Edit Project Settings.
   2.  Under Timed Snapshot(s) select None.
   3.  Under Startup Method, select from snapshot.  Modify the file name to match the file that was created.
   4.  Run the case."
    }
   -Wire-([1818,864],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1818,684],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Divider-([1710,36],0)
    {
    Size(0,1008)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([504,1044],0)
    {
    Size(0,486)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   0.multimeter([432,720],0,0,130)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V3"
    P = ""
    Q = ""
    Vrms = "V3rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([432,504],0,0,70)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V1"
    P = ""
    Q = ""
    Vrms = "V1rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([810,504],4,0,90)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V2"
    P = ""
    Q = ""
    Vrms = "V2rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([810,720],4,0,170)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V4"
    P = ""
    Q = ""
    Vrms = "V4rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   -Wire-([1782,1224],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1782,1224],0,0,-1)
    {
    Name = "V1rms"
    }
   -Wire-([1782,1260],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1782,1260],0,0,-1)
    {
    Name = "V2rms"
    }
   -Wire-([1782,1296],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1782,1296],0,0,-1)
    {
    Name = "V3rms"
    }
   -Wire-([1782,1332],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1782,1332],0,0,-1)
    {
    Name = "V4rms"
    }
   }
  }
 }

